% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitDynamicGrowth_class.R
\name{FitDynamicGrowth}
\alias{FitDynamicGrowth}
\alias{print.FitDynamicGrowth}
\alias{plot.FitDynamicGrowth}
\alias{summary.FitDynamicGrowth}
\alias{residuals.FitDynamicGrowth}
\alias{coef.FitDynamicGrowth}
\alias{vcov.FitDynamicGrowth}
\alias{deviance.FitDynamicGrowth}
\alias{fitted.FitDynamicGrowth}
\alias{predict.FitDynamicGrowth}
\title{FitDynamicGrowth class}
\usage{
\method{print}{FitDynamicGrowth}(x, ...)

\method{plot}{FitDynamicGrowth}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_y1 = "logN",
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = 1,
  point_col = "black",
  point_size = 3,
  point_shape = 16,
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed"
)

\method{summary}{FitDynamicGrowth}(object, ...)

\method{residuals}{FitDynamicGrowth}(object, ...)

\method{coef}{FitDynamicGrowth}(object, ...)

\method{vcov}{FitDynamicGrowth}(object, ...)

\method{deviance}{FitDynamicGrowth}(object, ...)

\method{fitted}{FitDynamicGrowth}(object, ...)

\method{predict}{FitDynamicGrowth}(object, times = NULL, newdata = NULL, ...)
}
\arguments{
\item{x}{The object of class \code{FitDynamicGrowth} to plot.}

\item{...}{ignored}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmenta factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link{geom_line}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link{geom_line}}}

\item{point_col}{Aesthetic parameter to change the colour of the point geom, see: \code{\link{geom_point}}}

\item{point_size}{Aesthetic parameter to change the size of the point geom, see: \code{\link{geom_point}}}

\item{point_shape}{Aesthetic parameter to change the shape of the point geom, see: \code{\link{geom_point}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{object}{an instance of \code{FitDynamicGrowth}.}

\item{times}{A numeric vector with the time points for the simulations. \code{NULL}
by default (using the same time points as those for the simulation).}

\item{newdata}{a tibble describing the environmental conditions (as \code{env_conditions})
in \code{\link{predict_dynamic_growth}}. 
If \code{NULL} (default), uses the same conditions as those for fitting.}
}
\description{
The \code{FitDynamicGrowth} class contains a model fitted based on growth data
under dynamic conditions. Its constructor is \code{\link{fit_dynamic_growth}}.

It is a subclass of list with the items:
     \itemize{
         \item fit_results: the object returned by \code{modFit}.
         \item best_prediction: the model prediction for the fitted parameters.
         \item env_conditions: environmental conditions for the fit.
         \item data: data used for the fit.
         \item starting: starting values for model fitting
         \item known: parameter values set as known.
         \item sec_models: a named vector with the secondary model
         for each environmental factor
         }
}
\section{Functions}{
\itemize{
\item \code{print.FitDynamicGrowth}: comparison between the fitted model and the data.

\item \code{plot.FitDynamicGrowth}: comparison between the fitted model and the data.

\item \code{summary.FitDynamicGrowth}: statistical summary of the fit.

\item \code{residuals.FitDynamicGrowth}: residuals of the model.

\item \code{coef.FitDynamicGrowth}: vector of fitted parameters.

\item \code{vcov.FitDynamicGrowth}: (unscaled) variance-covariance matrix of the model,
calculated as 1/(0.5*Hessian)

\item \code{deviance.FitDynamicGrowth}: deviance of the model.

\item \code{fitted.FitDynamicGrowth}: fitted values.

\item \code{predict.FitDynamicGrowth}: model predictions.
}}

