% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeatureTable-class.R,
%   R/gbRecord-class.R
\docType{methods}
\name{revcomp}
\alias{revcomp}
\alias{revcomp,gbFeatureTable-method}
\alias{revcomp,gbRecord-method}
\title{Reverse-complement features in a GenBank record}
\usage{
revcomp(x, order = TRUE, ...)

\S4method{revcomp}{gbFeatureTable}(x, order = TRUE)

\S4method{revcomp}{gbRecord}(x, order = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeatureTable}} or
\code{\linkS4class{gbRecord}} object (gbFeatureTables must 
be complete and include a 'source' field).}

\item{order}{Reorder features after reverse-complementing them.}

\item{...}{Additional arguments passed to methods.}
}
\description{
Reverse-complement features in a GenBank record
}
\examples{
load(system.file("extdata", "S_cerevisiae_mito.rda", package = "biofiles"))
xr <- revcomp(x)
}
