% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_table.R
\name{attribute_table}
\alias{attribute_table}
\title{Extract a volume coverage pattern table with all attributes}
\usage{
attribute_table(
  x,
  select = c("how.lowprf", "how.midprf", "how.highprf", "where.elangle", "where.nbins",
    "where.nrays", "where.rscale", "how.NI"),
  ...
)
}
\arguments{
\item{x}{Either a pvol or scan for which the table should be created.}

\item{select}{A character vector which the column names that should be returned when NULL all attributes are to be returned}

\item{...}{Currently not used

This function tabulates the attributes of one scan or all scans of a pvol.
Attributes that have a length longer then one are presented as a list column.
By default the function returns a limited set of columns to keep the output clear.
It is important to note that attributes of the full polar volume can contain additional information on processing that is not included in the resulting table.
This function only tabulates attributes of the scans.}
}
\description{
Extract a volume coverage pattern table with all attributes
}
\examples{
data(example_scan)
attribute_table(example_scan)

pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")
example_pvol <- read_pvolfile(pvolfile)
attribute_table(example_pvol)
}
