% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_sensitivities.R
\name{calculate_isothermal_FIM}
\alias{calculate_isothermal_FIM}
\title{Fisher Information Matrix for isothermal experiments}
\usage{
calculate_isothermal_FIM(model, exp_design, pars)
}
\arguments{
\item{model}{character defining the inactivation model according to the rules
in the \code{bioinactivation} package.}

\item{exp_design}{data.frame with two columns named \code{times} and 
\code{temperature} describing the experiment design.}

\item{pars}{list defining the model parameters according to the rules defined
in the \code{bioinactivation} package.}
}
\description{
Fisher Information Matrix for isothermal experiments
}
\examples{

library("dplyr")
time_profile <- seq(0, 50, length = 20)
Temp_profile <- seq(52.5,60, length = 3)

exp_design <- expand.grid(time_profile,Temp_profile) \%>\%
  rename(times = Var1, temperature = Var2)

pars <- list(temp_crit = 55,
             n = 1.5,
             k_b = 0.1)

calculate_isothermal_FIM("Peleg", exp_design, pars )
}
