% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_mode.R
\name{mode}
\alias{mode}
\title{Pretend to be Raw Data}
\usage{
mode(
  data,
  mode = "fit",
  sub_choose = "Sub_Choose",
  rob_choose = "Rob_Choose",
  raw_cols = c("Subject", "Block", "Trial", "L_choice", "R_choice", "L_reward",
    "R_reward", "Sub_Choose")
)
}
\arguments{
\item{data}{[list] a list resulting from the 'step7' process of the `output` function.}

\item{mode}{[character] 'fit' or 'simulate' whether to generate raw data.
Defaults to FALSE. Set to TRUE to generate fake data.
This produces a data frame with the same format as
the actual raw data.}

\item{sub_choose}{[character] column name of choices made by the subject. 
e.g., `sub_choose = "Choose"`}

\item{rob_choose}{[character] column name of choices made by the model. 
e.g., `rob_choose = "Rob_Choose"`
you should ignore this argument}

\item{raw_cols}{[vector] default: c("Subject", "Block", "Trial", 
"L_choice", "R_choice", "L_reward", "R_reward", "Choose", "Reward")
These are the column names of the raw data. 
Only required when `back = 'simulate'`.}
}
\value{
binaryRL[list]:
  \itemize{
    \item{\code{data}: new raw data (decision made by robot)}
    \item{\code{params}: all parameters value}
    \item{\code{numeric}: ACC}
    \item{\code{numeric}: LogL}
    \item{\code{numeric}: AIC}
    \item{\code{numeric}: BIC}
  }
}
\description{
Pretend to be Raw Data
}
