% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-test-data.R
\name{bike_rm_test_data}
\alias{bike_rm_test_data}
\title{Removes test data written with 'bike_write_test_data()'}
\usage{
bike_rm_test_data(data_dir = tempdir())
}
\arguments{
\item{data_dir}{Directory in which data were extracted.}
}
\value{
Number of files successfully removed, which should equal six.
}
\description{
The function \code{bike_write_test_data()} writes several small
zip-compressed files to disk. The default location is \code{tempdir()}, in
which case these files will be automatically removed on termination of
current R session. If, however, any other value for \code{data_dir} is passed
to \code{bike_write_test_data()}, then the resultant files ought be deleted
by calling this function.
}
\examples{
\dontrun{
bike_write_test_data ()
list.files (tempdir ())
bike_rm_test_data ()

bike_write_test_data (data_dir = getwd ())
list.files ()
bike_rm_test_data (data_dir = getwd ())
}
}
