% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-alleles.R
\name{snp_asGeneticPos}
\alias{snp_asGeneticPos}
\title{Interpolate to genetic positions}
\usage{
snp_asGeneticPos(
  infos.chr,
  infos.pos,
  dir = tempdir(),
  ncores = 1,
  rsid = NULL
)
}
\arguments{
\item{infos.chr}{Vector of integers specifying each SNP's chromosome.\cr
Typically \verb{<bigSNP>$map$chromosome}.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{dir}{Directory where to download and decompress files.
Default is \code{tempdir()}. Directly use files there if already present.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{rsid}{If providing rsIDs, the matching is performed using those
(instead of positions) and variants not matched are interpolated using
spline interpolation of variants that have been matched.}
}
\value{
The new vector of genetic positions.
}
\description{
Use genetic maps available at
\url{https://github.com/joepickrell/1000-genomes-genetic-maps/}
to interpolate physical positions (in bp) to genetic positions (in cM).
}
