% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld-scores.R
\name{snp_ld_scores}
\alias{snp_ld_scores}
\alias{bed_ld_scores}
\title{LD scores}
\usage{
snp_ld_scores(
  Gna,
  ind.row = rows_along(Gna),
  ind.col = cols_along(Gna),
  size = 500,
  infos.pos = NULL,
  ncores = 1
)

bed_ld_scores(
  obj.bed,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  size = 500,
  infos.pos = NULL,
  ncores = 1
)
}
\arguments{
\item{Gna}{A \link[bigstatsr:FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
You can have missing values in these data.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{size}{For one SNP, window size around this SNP to compute correlations.
Default is \code{500}. If not providing \code{infos.pos} (\code{NULL}, the default), this is
a window in number of SNPs, otherwise it is a window in kb (genetic distance).}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}.}

\item{obj.bed}{Object of type \link{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}
}
\value{
A vector of LD scores. For each variant, this is the sum of squared
correlations with the neighboring variants (including itself).
}
\description{
LD scores
}
\examples{
test <- snp_attachExtdata()
G <- test$genotypes

(ld <- snp_ld_scores(G, ind.col = 1:1000))

}
