% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{fwrite2}
\alias{fwrite2}
\title{Write a data frame to a text file}
\usage{
fwrite2(x, file, ..., quote = FALSE,
  nThread = getOption("bigreadr.nThread"))
}
\arguments{
\item{x}{Data frame to write.}

\item{file}{Path to the file that you want to write to.}

\item{...}{Other arguments to be passed to \link[data.table:fwrite]{data.table::fwrite}.}

\item{quote}{Whether to quote strings (default is \code{FALSE}).}

\item{nThread}{Number of threads to use. Default uses all threads minus one.}
}
\value{
Input parameter \code{file}, invisibly.
}
\description{
Write a data frame to a text file
}
\examples{
tmp <- fwrite2(iris, tempfile())
iris2 <- fread2(tmp)
all.equal(iris2, iris)  ## fread doesn't use factors
}
