% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_layer_conductance.r
\name{Gb.Thom}
\alias{Gb.Thom}
\title{Boundary Layer Conductance according to Thom 1972}
\usage{
Gb.Thom(ustar, constants = bigleaf.constants())
}
\arguments{
\item{ustar}{Friction velocity (m s-1)}

\item{constants}{k - von-Karman constant (-) \cr
Rbwc - Ratio of the transfer efficiency through the boundary layer for water vapor and CO2 (-)}
}
\value{
a data.frame with the following columns:
 \item{Rb}{Boundary layer resistance for heat and water (s m-1)}
 \item{Rb_CO2}{Boundary layer resistance for CO2 (s m-1)}
 \item{Gb}{Boundary layer conductance (m s-1)}
 \item{kB}{kB-1 parameter (-)}
}
\description{
An empirical formulation for the canopy boundary layer conductance 
             to heat/water vapor based on a simple ustar dependency.
}
\details{
The empirical equation for Rb to water suggested by Thom 1972 is:
 
   \deqn{Rb = 6.2ustar^-0.67}
 
 Rb for water vapor and heat is assumed to be equal. Rb for CO2 (Rb_CO2) is given as:
 
   \deqn{Rb_CO2 = 1.37 * Rb}
 
 The factor 1.37 arises due the lower molecular diffusivity of CO2 compared to water.
 It is lower than the ratio of the molecular diffusivities (Dw/DCO2 = 1.6), as movement
 across the boundary layer is assumed to be partly by diffusion and partly by turbulent
 mixing (Nobel 2005).
}
\examples{
Gb.Thom(seq(0.1,1.4,0.1))

}
\references{
Thom, A., 1972: Momentum, mass and heat exchange of vegetation.
            Quarterly Journal of the Royal Meteorological Society 98, 124-134.
            
            Nobel, P. S., 2005: Physicochemical and Environmental Plant Physiology. Third 
            Edition. Elsevier Academic Press, Burlington, USA.
}
\seealso{
\code{\link{Gb.Choudhury}}, \code{\link{Gb.Su}}, \code{\link{aerodynamic.conductance}}
}
