% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hergm.R
\name{draw_between_block_connection}
\alias{draw_between_block_connection}
\title{Draw between-block connections.}
\usage{
draw_between_block_connection(
  formula_for_simulation,
  sorted_dataframe,
  coef_between_block,
  seed_edgelist_between = NULL,
  use_fast_between_simulation = FALSE,
  list_feature_matrices = NULL,
  seed = NULL,
  n_sim = 1,
  prevent_duplicate = TRUE,
  verbose = 0,
  ergm_control = ergm::control.simulate.formula(),
  output = "edgelist",
  ...
)
}
\arguments{
\item{formula_for_simulation}{formula for simulating a between-block network}

\item{sorted_dataframe}{a data frame with the covariate information. The order must match the nodes in the network and it must contain the coliumn 'vertex_id' matching the network.}

\item{coef_between_block}{a vector of between-block parameters. The order of the parameters should match that of the formula.}

\item{seed_edgelist_between}{a seed edgelist from which a between-block network is simulated.}

\item{use_fast_between_simulation}{If \code{TRUE}, this function uses an effcient way to simulate a between-block network.
If the network is very large, you should consider using this option.
Note that when you use this, the first element of \code{coef_between_block} must be the edges parameter.}

\item{list_feature_matrices}{a list of feature adjacency matrices. This is used when \code{use_fast_between_simulation}.}

\item{seed}{seed value (integer) for the random number generator.}

\item{n_sim}{number of networks generated.}

\item{prevent_duplicate}{If \code{TRUE}, the coefficient on nodematch("block") is set to be a very large negative number in drawing between-block links,
so that there will be (almost) no within-block links.}

\item{verbose}{If this is TRUE/1, the program will print out additionalinformation about the progress of simulation.}

\item{ergm_control}{auxiliary function as user interface for fine-tuning ERGM simulation}

\item{output}{Normally character, one of "network" (default), "stats", "edgelist", to determine the output format.}

\item{...}{Additional arguments, to be passed to lower-level functions}
}
\value{
A \code{\link[ergm]{network.list}} object of the \code{n_sim} networks.
}
\description{
Draw between-block connections. There may be some edges that appear both in within- and between-block links.
The overlapped edges will be removed after this step.
}
\examples{
data(toyNet)

# Specify the model that you would like to estimate.
model_formula <- toyNet ~ edges + nodematch("x") + nodematch("y") 
# Estimate the model
nodes_data <- data.frame(
  vertex_id = 1:toyNet$gal$n,
  x = toyNet \%v\% "x",
  y = toyNet \%v\% "y",
  block = toyNet \%v\% "block"
)
list_feature_matrices <- 
   get_list_sparse_feature_adjmat(toyNet, model_formula)
toyNet <- network::as.edgelist(toyNet)

draw_between_block_connection(formula_for_simulation = model_formula, 
                              sorted_dataframe = nodes_data,
                              coef_between_block = c(-2,0.1,0.2),
                              n_sim = 10)

}
