% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudStorage.R
\name{gcs_update_acl}
\alias{gcs_update_acl}
\title{Update Google Cloud Storage ObjectAccessControls}
\usage{
gcs_update_acl(bucket, object, entity, entity_type = c("user", "group",
  "domian", "project", "allUsers", "allAuthenticatedUsers"),
  role = c("READER", "OWNER"))
}
\arguments{
\item{bucket}{Google Cloud Storage bucket}

\item{object}{Object to update}

\item{entity}{entity to update or add}

\item{entity_type}{what type of entity}

\item{role}{Access permission for entity}
}
\value{
TRUE if successful
}
\description{
Requires scopes set in bigQuery.scopes
  \code{https://www.googleapis.com/auth/devstorage.full_control}
  \code{https://www.googleapis.com/auth/cloud-platform}
}
\examples{

\dontrun{
library(bigQueryR)

## Auth with a project that has at least BigQuery and Google Cloud Storage scope
bqr_auth()

## make a big query
job <- bqr_query_asynch("your_project", 
                        "your_dataset",
                        "SELECT * FROM blah LIMIT 9999999", 
                        destinationTableId = "bigResultTable")
                        
## poll the job to check its status
## its done when job$status$state == "DONE"
bqr_get_job("your_project", job$jobReference$jobId)

##once done, the query results are in "bigResultTable"
## extract that table to GoogleCloudStorage:
# Create a bucket at Google Cloud Storage at 
# https://console.cloud.google.com/storage/browser

job_extract <- bqr_extract_data("your_project",
                                "your_dataset",
                                "bigResultTable",
                                "your_cloud_storage_bucket_name")
                                
## poll the extract job to check its status
## its done when job$status$state == "DONE"
bqr_get_job("your_project", job_extract$jobReference$jobId)

## to download via a URL and not logging in via Google Cloud Storage interface:
## Use an email that is Google account enabled
## Requires scopes:
##  https://www.googleapis.com/auth/devstorage.full_control
##  https://www.googleapis.com/auth/cloud-platform
## set via options("bigQueryR.scopes") and reauthenticate if needed

download_url <- bqr_grant_extract_access(job_extract, "your@email.com")

## download_url may be multiple if the data is > 1GB

}

}
\seealso{
\href{https://cloud.google.com/storage/docs/json_api/v1/objectAccessControls/insert}{objectAccessControls on Google API reference}

Other bigQuery upload functions: \code{\link{bqr_upload_data}}
}

