% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2bib.R
\name{df2bib}
\alias{df2bib}
\title{Export a BibTeX \code{tibble} to a .bib file}
\usage{
df2bib(x, file, append = FALSE)
}
\arguments{
\item{x}{\code{tibble}, returned by \code{\link{df2bib}}.}

\item{file}{character, path to a .bib file.}

\item{append}{logical, if \code{TRUE} the \code{tibble} will be appended to an existing file.}
}
\value{
\code{file} as a character string, invisibly.
}
\description{
The BibTeX \code{tibble} is written to a .bib file
}
\examples{
# Read from .bib file:
path <- system.file("extdata", "biblio.bib", package = "bib2df")
bib <- bib2df(path)

# Write to .bib file:
bibFile <- tempfile()
df2bib(bib, bibFile)

# Use `append = TRUE` to add lines to an existing .bib file:
df2bib(bib, bibFile, append = TRUE)
}
\references{
\url{http://www.bibtex.org/Format/}
}
\seealso{
\code{\link{bib2df}}
}
\author{
Thomas J. Leeper
}
