% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib2df.R
\name{bib2df}
\alias{bib2df}
\title{Parse a BibTeX file to a \code{data.frame}..}
\usage{
bib2df(file, separate_names = c(FALSE, TRUE))
}
\arguments{
\item{file}{character, path to a .bib file.}

\item{separate_names}{logical, should authors' and editors' names be separated into first and given name?}
}
\value{
A \code{data.frame}.
}
\description{
The BibTeX file is read, parsed, tidied and written to a \code{data.frame}..
}
\details{
Uses the internal \code{bib2df_read()}, \code{bib2df_gather()} and \code{bib2df_tidy()}. No magic, just a wrapper.
}
\examples{
path <- system.file("extdata", "biblio.bib", package = "bib2df")
bib2df(path)
}
\seealso{
\code{\link{df2bib}}
}
\author{
Philipp Ottolinger
}
