% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bhrcr}
\alias{plot.bhrcr}
\title{Bayesian Clearance Estimator Plotting}
\usage{
\method{plot}{bhrcr}(x, plot.post = T, id.plot = NULL, thin = NULL,
  ...)
}
\arguments{
\item{x}{output given by \code{clearanceEstimatorBayes}}

\item{plot.post}{indicator of whether or not the posterior samples should be plotted}

\item{id.plot}{patients' IDs}

\item{thin}{an optional vector showing which posterior samples to be plotted}

\item{...}{additional arguments passed to the \code{plot.bhrcr} function}
}
\value{
the directory location under which all the plots are saved.
}
\description{
\code{plot.bhrcr} plots the posterior results from \code{clearanceEstimatorBayes}.
}
\details{
This function plots clearance profile of each individual along with their fitted Bayesian model, 
Flegg's PCE estimates, and posterior samples.
}
\examples{
\dontshow{
data("pursat")
data("pursat_covariates")
data = pursat[pursat["id"] <= 80 & pursat["id"] > 70,]
covariates = pursat_covariates[71:80,]
out <- clearanceEstimatorBayes(data = data, covariates = covariates, outlier.detect = TRUE,
                              niteration = 3, burnin = 1, thin = 1)
plot(out)
}
\donttest{
data("posterior")
plot(posterior)
}
\donttest{
data("pursat")
data("pursat_covariates")
out <- clearanceEstimatorBayes(data = pursat, covariates = pursat_covariates, 
                               niteration = 200, burnin = 50, thin = 10)
plot(out)
}
}
\author{
Colin B. Fogarty <cfogarty@mit.edu>, Saeed Sharifi-Malvajerdi <saeedsh@wharton.upenn.edu>, Feiyu Zhu <feiyuzhu@sas.upenn.edu>
}
