% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgg_tools.R
\name{bgg_topgames}
\alias{bgg_topgames}
\title{Get IDs of top rated games on BoardGameGeek}
\usage{
bgg_topgames(places = 1:100)
}
\arguments{
\item{places}{a numeric vector of positive integers.}
}
\value{
Numeric vector of IDs.
}
\description{
This function scraps BoardGameGeek website for IDs of games with given
\code{places} in the games ranking.
}
\examples{
bgg_topgames()

x <- 1:10 * 25 + 5
ids <- bgg_topgames(sample(x))
gm <- bggGames$new(ids)
gm$expand(c("name", "rank"))
gm

}
\author{
Jakub Bujnowicz \email{bujnowiczgithub@gmail.com}
}
