# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' C++ function for generating  p from v in Stick Breaking DP representation
#' @keywords internal
pFromV <- function(v) {
    .Call(`_beyondWhittle_pFromV`, v)
}

#' C++ function for generating  v from p (inverse stick breaking)
#' NOTE: p is assumed to have length L, i.e. it does NOT contain p_0 !!
#' @keywords internal
vFromP <- function(p, eps = 1e-8) {
    .Call(`_beyondWhittle_vFromP`, p, eps)
}

#' C++ function for computing mixture weights of Bernstein-Mixtures given the probabilities p, values w, and degree k.
#' @keywords internal
mixtureWeight <- function(p, w, k) {
    .Call(`_beyondWhittle_mixtureWeight`, p, w, k)
}

#' C++ function for building a density mixture, given mixture weights and functions.
#' @keywords internal
densityMixture <- function(weights, densities) {
    .Call(`_beyondWhittle_densityMixture`, weights, densities)
}

#' C++ help function to redundantly roll out a PSD to length n
#' @keywords internal
unrollPsd <- function(qPsd, n) {
    .Call(`_beyondWhittle_unrollPsd`, qPsd, n)
}

#' C++ function for generating epsilon process for MA(q)
#' @keywords internal
genEpsMAC <- function(zt, ma) {
    .Call(`_beyondWhittle_genEpsMAC`, zt, ma)
}

#' C++ function for computing ACV function, given PACF and variance.
#' @keywords internal
pacf2ARacv <- function(pacf, sigma2) {
    .Call(`_beyondWhittle_pacf2ARacv`, pacf, sigma2)
}

#' C++ function for computing AR coefficients, given PACF.
#' @keywords internal
pacf2AR <- function(pacf) {
    .Call(`_beyondWhittle_pacf2AR`, pacf)
}

#' C++ function for generating epsilon process for AR(p)
#' @keywords internal
genEpsARC <- function(zt, ar) {
    .Call(`_beyondWhittle_genEpsARC`, zt, ar)
}

#' C++ function for generating epsilon process for ARMA(p,q)
#' @keywords internal
genEpsARMAC <- function(zt, ar, ma) {
    .Call(`_beyondWhittle_genEpsARMAC`, zt, ar, ma)
}

#' Compute the ARMA(p,q) spectral density
#' 
#' Compute the ARMA(p,q) spectral density evaluated at some frequencies freq in [0,pi),
#' Note that no test for model stationarity is performed.
#' @param freq numeric vector of frequencies to evaluate the psd, 0 <= freq < pi
#' @param ar autoregressive coefficients of ARMA model (use numeric(0) for empty AR part)
#' @param ma moving average coefficients of ARMA model (use numeric(0) for empty MA part)
#' @param sigma2 the model innovation variance
#' @return numeric vector of the (real-valued) spectral density values
#' @export
psd_arma <- function(freq, ar, ma, sigma2 = 1.0) {
    .Call(`_beyondWhittle_psd_arma`, freq, ar, ma, sigma2)
}

#' C++ function to build a Toeplitz ACV matric, given an ACV vector.
#' @keywords internal
acvMatrix <- function(acv) {
    .Call(`_beyondWhittle_acvMatrix`, acv)
}

#' C++ function for computing acceptance rate based on trace
#' Note: Only use for traces from continous distributions!
#' @keywords internal
acceptanceRate <- function(trace) {
    .Call(`_beyondWhittle_acceptanceRate`, trace)
}

