% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bexy.R
\name{plotMCMCTrace}
\alias{plotMCMCTrace}
\title{Plot the MCMC trace for a specific parameter}
\usage{
plotMCMCTrace(object, parameterName, maxNumPlots = 20)
}
\arguments{
\item{object}{A bexy object.}

\item{parameterName}{The name of the parameter to plot (e.g. rho, logSigma, epsilon, s, t, a, f, ...)}

\item{maxNumPlots}{The maximum number of plots to plot, default 20.}
}
\value{
No return value, called for side effects.
}
\description{
Plot the MCMC trace for a specific parameter
}
\examples{
bex <- bexy(readMCMCTrace = TRUE)
plotMCMCTrace(bex, "rho", maxNumPlots = 1)
}
\seealso{
\code{\link{bexy}}
}
