% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-methods-beta-nb.R
\name{confint.betanb}
\alias{confint.betanb}
\title{Confidence Intervals Method for an Object of Class
\code{betanb}}
\usage{
\method{confint}{betanb}(object, parm = NULL, level = 0.95, type = "pc", ...)
}
\arguments{
\item{object}{Object of Class \code{betanb},
that is,
the output of the
\code{BetaNB()},
\code{RSqNB()},
\code{SCorNB()},
\code{DeltaRSqNB()}, or
\code{PCorNB()}
functions.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{Charater string.
Confidence interval type, that is,
\code{type = "pc"} for percentile;
\code{type = "bc"} for bias corrected;
\code{type = "bca"} for bias corrected and accelerated.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals Method for an Object of Class
\code{betanb}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate bootstrap covariance matrices
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
std <- BetaNB(nb)
# Method ---------------------------------------------------------
confint(std, level = 0.95, type = "pc")
confint(std, level = 0.95, type = "bc")
confint(std, level = 0.95, type = "bca")
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
