% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{RMSE}
\usage{
rmse(a, b, quiet = FALSE)
}
\arguments{
\item{a}{Vector with values.}

\item{b}{Another vector of the same length.}

\item{quiet}{Should NA-removal warnings be suppressed? Helpful within functions. DEFAULT: FALSE}
}
\value{
Numeric.
}
\description{
Root Mean Squared Error
}
\details{
Formula used: \code{sqrt( sum((a-b)^2)/length(b) )}
}
\examples{

x <- rnorm(20)
y <- 2*x + rnorm(20)
plot(x,y)
yp <- predict(lm(y~x))
plot(y, yp)
abline(a=0,b=1)
rmse(y,yp)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2014
}
\references{
\url{http://en.wikipedia.org/wiki/Mean_squared_error}
}
\seealso{
\code{\link{rsquare}}
}
\keyword{univar}

