% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ucld_mean_state_node_param_xml.R
\name{create_ucld_mean_state_node_param_xml}
\alias{create_ucld_mean_state_node_param_xml}
\title{Internal function}
\usage{
create_ucld_mean_state_node_param_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the XML
\code{
  <parameter id=\"ucldMean.c:[id]\" spec=\"parameter.RealParameter\"
    name=\"stateNode\">1.0</parameter>
}
}
\description{
Creates the \code{ucldMean.c} parameter with the name \code{stateNode},
such as:
\code{
  <parameter id=\"ucldMean.c:[id]\" spec=\"parameter.RealParameter\"
    name=\"stateNode\">1.0</parameter>
}
}
\examples{
check_empty_beautier_folder()

create_ucld_mean_state_node_param_xml(
  create_inference_model(
    clock_model = create_rln_clock_model(id = 314),
    beauti_options = create_beauti_options_v2_6()
  )
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
