% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beastier.R
\docType{package}
\name{beastier}
\alias{beastier}
\title{\code{beastier}: A package to call BEAST2.}
\description{
\code{beastier} allows to call BEAST2, a popular
Bayesian phylogenetics tool, using
an R interface. 'beastier' closely follows the interface
of BEAST2, including its default settings.
}
\examples{
beast2_options <- create_beast2_options(
  input_filename = get_beastier_path("2_4.xml")
)

if (is_beast2_installed() && is_on_ci()) {
  run_beast2_from_options(beast2_options)
}
}
\seealso{
These are packages associated with \code{beastier}:
\itemize{
  \item{
    The package \code{beautier} can create
    BEAST2 input files from R
  }
  \item{
    The package \code{tracerer} can parse
    BEAST2 output files from R
  }
  \item{
    The package \code{babette} combines the
    functionality of \code{beautier},
    \code{beastier} and \code{tracerer}
    into a single workflow
  }
}
}
