% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsvd.R
\name{single.bdsvd}
\alias{single.bdsvd}
\title{Single Iteration of Block Detection Using Singular Vectors (BD-SVD).}
\usage{
single.bdsvd(X, dof, standardize = TRUE, max.iter)
}
\arguments{
\item{X}{Data matrix of dimension \eqn{n x p} with possibly \eqn{p >> n}.}

\item{dof}{Number of non-zero components in the sparse loading (degrees of freedom). If
\eqn{S} denotes the support of \eqn{v}, then the cardinality of the support, \eqn{|S|},
corresponds to the degrees of freedom.}

\item{standardize}{Standardize the data to have unit variance. Default is \code{TRUE}.}

\item{max.iter}{How many iterations should be performed for computing the sparse loading.
Default is \code{200}.}
}
\value{
A list containing the feature names of the submatrices of \code{X}. It is either of length one (no
split) or length two (split into two submatrices).
}
\description{
Performs a single iteration of BD-SVD: splits the data matrix into one (i.e., no split)
or two submatrices, depending on the structure of the first sparse loading \eqn{v} (which is a sparse
approximation of the first right singular vector, i.e., a vector with many zero values) that mirrors the
shape of the covariance matrix.
}
\details{
The sparse loadings are computed using the method by Shen & Huang (2008), implemented in
the \code{irlba} package.
}
\examples{
#Replicate the illustrative example from Bauer (202Xa).

p <- 300 #Number of variables. In Bauer (202Xa), p = 3000.
n <- 500 #Number of observations
b <- 3   #Number of blocks
design <- "c"

#Simulate data matrix X
set.seed(1)
Sigma <- bdsvd.cov.sim(p = p, b = b, design = design)
X <- mvtnorm::rmvnorm(n, mean=rep(0, p), sigma=Sigma)
colnames(X) <- 1:p

ht <- bdsvd.ht(X)
plot(0:(p-1), ht$BIC[,1], xlab = "|S|", ylab = "HBIC", main = "", type = "l")
single.bdsvd(X, dof = ht$dof, standardize = FALSE)

}
\references{
\cite{Bauer, J.O. (202Xa). High-dimensional block diagonal covariance structure detection using singular vectors.}

\cite{Shen, H. and Huang, J.Z. (2008). Sparse principal component analysis via regularized low rank matrix approximation, J. Multivar. Anal. 99, 1015–1034.}
}
\seealso{
\link{bdsvd}, \link{bdsvd.ht}
}
