% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorSms.R
\docType{class}
\name{ExtractorSms}
\alias{ExtractorSms}
\title{Class to handle SMS files with tsms extension}
\usage{
ExtractorSms
}
\description{
This class that inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an tsms type file.
}
\section{Constructor}{

\code{ExtractorSms$new(path)}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path of the tsms type file.
}
}
}
}
}

\section{Details}{

Due to the fact that the creation date of the message can not be
extracted from the text of an SMS, the date will be initialized to empty.
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\section{Methods}{

\itemize{
\item{\bold{obtainDate:}}{
function that obtains the date of the SMS file.
\itemize{
\item{\emph{Usage:}}{
\code{obtainDate()}
}
}
}
\item{\bold{obtainSource:}}{
obtains the source of the SMS file. Reads the file indicated in
the path. In addition, it initializes the data with the initial source.
\itemize{
\item{\emph{Usage:}}{
\code{obtainSource()}
}
}
}
}
}

\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorTwtid}},
\code{\link{ExtractorYtbid}}, \code{\link{Instance}}
}
