% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{interval.prob}
\alias{interval.prob}
\title{Estimate the probability of a change point in a specified interval}
\usage{
interval.prob(object, start, end)
}
\arguments{
\item{object}{the result of a call to \code{bcp()}.}

\item{start}{the starting index of the interval.}

\item{end}{the ending index of the interval.}
}
\description{
The function \code{interval.prob()} estimates the probability of at least one
change point in the specified interval of sequential observations; it may only be used when \code{return.mcmc=TRUE}.
}
\details{
For sequential data only, the function returns an estimate of the posterior probability of at least one change point in the specified interval.
}
\note{
\code{return.mcmc} must be \code{TRUE}.
}
\examples{
##### A random sample from a few normal distributions #####
testdata <- c(rnorm(50), rnorm(50, 5, 1), rnorm(50))
bcp.0 <- bcp(testdata, return.mcmc=TRUE)
plot(bcp.0, main="Univariate Change Point Example")
interval.prob(bcp.0, 45, 55)

}
\seealso{
\code{\link{bcp}} and \code{\link{plot.bcp}}.
}
\author{
Xiaofei Wang, Chandra Erdman, and John W. Emerson
}
\keyword{datasets}
