% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerBatchChain.R
\name{mlr_optimizers_chain}
\alias{mlr_optimizers_chain}
\alias{OptimizerBatchChain}
\title{Run Optimizers Sequentially}
\description{
\code{OptimizerBatchChain} allows to run multiple \link{OptimizerBatch} sequentially.

For each \link{OptimizerBatch} an (optional) additional \link{Terminator} can be specified during construction.
While the original \link{Terminator} of the \link{OptimInstanceBatch} guards the optimization process as a whole,
the additional \link{Terminator}s guard each individual \link{OptimizerBatch}.

The optimization process works as follows:
The first \link{OptimizerBatch} is run on the \link{OptimInstanceBatch} relying on a \link{TerminatorCombo} of the original
\link{Terminator} of the \link{OptimInstanceBatch} and the (optional) additional \link{Terminator} as passed during construction.
Once this \link{TerminatorCombo} indicates termination (usually via the additional \link{Terminator}), the second \link{OptimizerBatch} is run.
This continues for all optimizers unless the original \link{Terminator} of the \link{OptimInstanceBatch} indicates termination.

\link{OptimizerBatchChain} can also be used for random restarts of the same
\link{Optimizer} (if applicable) by setting the \link{Terminator} of the \link{OptimInstanceBatch} to
\link{TerminatorNone} and setting identical additional \link{Terminator}s during construction.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("chain")
opt("chain")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

Parameters are inherited from the individual \link{OptimizerBatch} and collected as a
\link[paradox:ParamSetCollection]{paradox::ParamSetCollection} (with \code{set_id}s potentially postfixed via \verb{_1}, \verb{_2},
..., if the same \link{OptimizerBatch} are used multiple times).
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
library(paradox)

domain = ps(x = p_dbl(lower = -1, upper = 1))

search_space = ps(x = p_dbl(lower = -1, upper = 1))

codomain = ps(y = p_dbl(tags = "minimize"))

objective_function = function(xs) {
 list(y = as.numeric(xs)^2)
}

objective = ObjectiveRFun$new(
 fun = objective_function,
 domain = domain,
 codomain = codomain
)

terminator = trm("evals", n_evals = 10)

# run optimizers sequentially
instance = OptimInstanceBatchSingleCrit$new(
 objective = objective,
 search_space = search_space,
 terminator = terminator
)

optimizer = opt("chain",
 optimizers = list(opt("random_search"), opt("grid_search")),
 terminators = list(trm("evals", n_evals = 5), trm("evals", n_evals = 5))
)

optimizer$optimize(instance)

# random restarts
instance = OptimInstanceBatchSingleCrit$new(
 objective = objective,
 search_space = search_space,
 terminator = trm("none")
)
optimizer = opt("chain",
 optimizers = list(opt("gensa"), opt("gensa")),
 terminators = list(trm("evals", n_evals = 10), trm("evals", n_evals = 10))
)
optimizer$optimize(instance)
}
\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch}} -> \code{OptimizerBatchChain}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerBatchChain-new}{\code{OptimizerBatchChain$new()}}
\item \href{#method-OptimizerBatchChain-clone}{\code{OptimizerBatchChain$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimizerBatch" data-id="optimize"><a href='../../bbotk/html/OptimizerBatch.html#method-OptimizerBatch-optimize'><code>bbotk::OptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchChain-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchChain-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchChain$new(
  optimizers,
  terminators = rep(list(NULL), length(optimizers))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optimizers}}{(list of \link{Optimizer}s).}

\item{\code{terminators}}{(list of \link{Terminator}s | NULL).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerBatchChain-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerBatchChain-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerBatchChain$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
