% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{randompar}
\alias{randompar}
\title{Generate Random Parameters}
\usage{
randompar(predictors, distr = "unif", h0 = 0, dh = 1, J0 = 0, dJ = 1)
}
\arguments{
\item{predictors}{List of predictor factor levels. See \code{\link{bbl}}.}

\item{distr}{\code{c('unif','norm')} for uniform or normal distributions.}

\item{h0}{Mean of bias parameters}

\item{dh}{\code{sd} of bias if \code{distr = 'unif'}. If \code{distr = 'norm'},
\eqn{h = [h_0-dh, h_0+dh]}.}

\item{J0}{Mean of interaction parameters.}

\item{dJ}{\code{sd} of interactions if \code{distr = 'unif'}. 
If \code{distr = 'norm'}, \eqn{J = [J_0-dJ, J_0+dJ]}.}
}
\value{
List of parameters, \code{h} and \code{J}.
}
\description{
Random values of bias and interaction parameters are generated
using either uniform or normal distributions.
}
\details{
Input argument \code{predictors} is used to set up proper list 
structures of parameters.
}
\examples{
set.seed(311)
predictors <- list()
for(i in 1:5) predictors[[i]] <- c('a','c')
par <- randompar(predictors=predictors)
par
}
