% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bayou-plotting.R
\name{plotSimmap.mcmc}
\alias{plotSimmap.mcmc}
\title{Plot a phylogenetic tree with posterior probabilities from a bayouMCMC chain (function adapted from phytools' plotSimmap)}
\usage{
plotSimmap.mcmc(chain, burnin = NULL, lwd = 1, edge.type = c("theta",
  "none", "regimes", "pp"), pal = rainbow, pp.cutoff = 0.3,
  circles = TRUE, circle.cex.max = 3, circle.col = "red",
  circle.pch = 21, circle.lwd = 0.75, circle.alpha = 100,
  pp.labels = FALSE, pp.col = 1, pp.alpha = 255, pp.cex = 0.75,
  edge.color = 1, parameter.sample = 1000, ...)
}
\arguments{
\item{chain}{A bayouMCMC chain}

\item{burnin}{The proportion of runs to be discarded, if NULL, then the value stored in the bayouMCMC chain's attributes is used}

\item{lwd}{The width of the edges}

\item{edge.type}{Either "theta" (branches will be colored according to their median value of theta), "regimes" (clades will be assigned to distinct regimes if the posterior probability of a shift
on that branch is > pp.cutoff), or "pp" (branches will be colored according to the probability of a shift on that branch). If "none" then edge.color will be assigned to all branches.}

\item{pal}{A color palette function used to paint the branches (unless edge.type="none")}

\item{pp.cutoff}{If edge.type=="regimes", the posterior probability above which a shift should be reconstructed on the tree.}

\item{circles}{a logical value indicating whether or not a circle should be plotted at the base of the node with values that correspond to the posterior probability of having a shift.}

\item{circle.cex.max}{The cex value of a circle with a posterior probability of 1}

\item{circle.col}{The color used to fill the circles}

\item{circle.pch}{the type of symbol used to plot at the node to indicate posterior probability}

\item{circle.lwd}{the line width of the points plotted at the nodes}

\item{circle.alpha}{a value between 0 and 255 that indicates the transparency of the circles (255 is completely opaque).}

\item{pp.labels}{a logical indicating whether the posterior probability for each branch should be printed above the branch}

\item{pp.col}{The color used for the posterior probability labels}

\item{pp.alpha}{a logical or numeric value indicating transparency of posterior probability labels. If TRUE, then transparency is ramped from invisible (pp=0), to black (pp=1). If numeric, all labels are given the same transparency. If NULL, then no transparency is given.}

\item{pp.cex}{the size of the posterior probability labels}

\item{edge.color}{The color of edges if edge.type="none"}

\item{parameter.sample}{When edge.type=="theta", the number of samples used to estimate the median "theta" value from each branch. Since this is
computationally intensive, this enables you to downsample the chain.}

\item{...}{Additional arguments passed to ape's plot.phylo}
}
\description{
Plot a phylogenetic tree with posterior probabilities from a bayouMCMC chain (function adapted from phytools' plotSimmap)
}

