% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot_grid.R
\name{bayesplot_grid}
\alias{bayesplot_grid}
\title{Arrange plots in a grid}
\usage{
bayesplot_grid(..., plots = list(), xlim = NULL, ylim = NULL,
  grid_args = list(), titles = character(), subtitles = character(),
  legends = TRUE, save_gg_objects = TRUE)
}
\arguments{
\item{...}{One or more ggplot objects.}

\item{plots}{A list of ggplot objects. Can be used as an alternative to
specifying plot objects via \code{...}.}

\item{xlim, ylim}{Optionally, numeric vectors of length 2 specifying lower and
upper limits for the axes that will be shared across all plots.}

\item{grid_args}{An optional named list of arguments to pass to
\code{\link[gridExtra]{arrangeGrob}} (\code{nrow}, \code{ncol},
\code{widths}, etc.).}

\item{titles, subtitles}{Optional character vectors of plot titles and
subtitles. If specified, \code{titles} and \code{subtitles} must must have
length equal to the number of plots specified.}

\item{legends}{If any of the plots have legends should they be displayed?
Defaults to \code{TRUE}.}

\item{save_gg_objects}{If \code{TRUE}, the default, then the ggplot objects
specified in \code{...} or via the \code{plots} argument are saved in a
list in the \code{"bayesplots"} component of the returned object.
Setting this to \code{FALSE} will make the returned object smaller but
these individual plot objects will not be available.}
}
\value{
An object of class "bayesplot_grid" (essentially a gtable object from
  \code{\link[gridExtra]{arrangeGrob}}), which has a \code{plot} method.
}
\description{
The \code{bayesplot_grid} function makes it simple to juxtapose plots using
common \eqn{x} and/or \eqn{y} axes.
}
\examples{
y <- example_y_data()
yrep <- example_yrep_draws()
stats <- c("sd", "median", "max", "min")

color_scheme_set("pink")
bayesplot_grid(
 plots = lapply(stats, function(s) ppc_stat(y, yrep, stat = s)),
 titles = stats,
 legends = FALSE,
 grid_args = list(ncol = 1)
)

\dontrun{
library(rstanarm)
mtcars$log_mpg <- log(mtcars$mpg)
fit1 <- stan_glm(mpg ~ wt, data = mtcars)
fit2 <- stan_glm(log_mpg ~ wt, data = mtcars)

y <- mtcars$mpg
yrep1 <- posterior_predict(fit1, draws = 50)
yrep2 <- posterior_predict(fit2, fun = exp, draws = 50)

color_scheme_set("blue")
ppc1 <- ppc_dens_overlay(y, yrep1)
ppc1
ppc1 + yaxis_text()

color_scheme_set("red")
ppc2 <- ppc_dens_overlay(y, yrep2)
bayesplot_grid(ppc1, ppc2)

# make sure the plots use the same limits for the axes
bayesplot_grid(ppc1, ppc2, xlim = c(-5, 60), ylim = c(0, 0.2))

# remove the legends and add text
bayesplot_grid(ppc1, ppc2, xlim = c(-5, 60), ylim = c(0, 0.2),
               legends = FALSE, subtitles = rep("Predicted MPG", 2))
}

}
