% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fitted.R
\name{compare_fitted}
\alias{compare_fitted}
\title{compare_fitted}
\usage{
compare_fitted(x, resolution = 50, x_range = NA, make_newdata = TRUE, ...)
}
\arguments{
\item{x}{A named \code{\link[base]{list}} of objects of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} returned by
\code{\link{bnec}}.}

\item{resolution}{The number of unique x values over which to find ECx --
large values will make the ECx estimate more precise.}

\item{x_range}{A range of x values over which to consider extracting ECx.}

\item{make_newdata}{Should the
user allow the package to create \code{newdata} for predictions?
If so, arguments \code{resolution} and \code{x_range} will be used. Defaults
to TRUE. See details.}

\item{...}{Further arguments that control posterior predictions via
\code{\link[brms]{posterior_epred}}.}
}
\value{
A named \code{\link[base]{list}} containing bootstrapped differences
in posterior predictions of the \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} model fits contained in \code{x}. See Details.
}
\description{
Extracts posterior predicted values from a list of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}} model fits and
compares these across a vector of fitted values.
}
\details{
The argument \code{make_newdata} is relevant to those who want the
package to create a data.frame from which to make predictions. This is done
via \code{\link{bnec_newdata}} and uses arguments \code{resolution} and
\code{x_range}. If \code{make_newdata = FALSE} and no additional
\code{newdata} argument is provided (via \code{...}), then the predictions
are made for the raw data. Else, to generate predictions for a specific
user-specific data.frame, set \code{make_newdata = FALSE} and provide
an additional data.frame via the \code{newdata} argument. For guidance
on how to structure \code{newdata}, see for example
\code{\link[brms]{posterior_epred}}.
}
\examples{
\dontrun{
library(bayesnec)
data(manec_example)
nec4param <- pull_out(manec_example, model = "nec4param")
ecx4param <- pull_out(manec_example, model = "ecx4param")
compare_fitted(list("nec" = ecx4param, "ecx" = nec4param))
}

}
\seealso{
\code{\link{bnec}}
}
