% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-bayesian_structural_reg.R
\name{bayesian_structural_reg}
\alias{bayesian_structural_reg}
\title{General Interface for Bayesian Structural Time Series Models}
\usage{
bayesian_structural_reg(mode = "regression", distribution = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{distribution}{The model family for the observation equation.
Non-Gaussian model families use data augmentation to recover a conditionally Gaussian model.}
}
\value{
A model spec
}
\description{
\code{bayesian_structural_reg()} is a way to generate a \emph{specification} of a Bayesian Structural Time Series Model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{bsts}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{bayesian_structural_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "stan" (default) - Connects to \code{\link[bsts:bsts]{bsts::bsts()}}
}

\strong{Main Arguments}

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.

\strong{stan (default engine)}

The engine uses \code{\link[bsts:bsts]{bsts::bsts()}}.

Parameter Notes:
\itemize{
\item \code{xreg} - This is supplied via the parsnip / modeltime \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
}
}
\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} or \code{fit_xy()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{arima_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
\dontrun{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)
library(bayesmodels)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

ss <- AddLocalLinearTrend(list(), training(splits)$value)

# Model Spec
model_spec <- bayesian_structural_reg() \%>\%
    set_engine("stan", state.specification = ss)

# Fit Spec
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit

predict(model_fit, testing(splits))

}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
