% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{LocalLevel}
\alias{LocalLevel}
\title{A  constructor for local level state-space model.}
\usage{
LocalLevel(ts,xreg = NULL,genT = FALSE,series.name = NULL)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{genT}{a boolean value to specify for a generalized t-student SSM model.}

\item{series.name}{an optional string vector with the time series names.}
}
\value{
The function returns a list with the data for running \code{stan()} function of
\pkg{rstan} package.
}
\description{
Constructor of the \code{ets("A","N","N")} object for Bayesian estimation in \pkg{Stan}.
}
\details{
The function returns a list with the data for running \code{stan()} function of
\pkg{rstan} package.

By  default  the  \code{ssm()}  function generates a local level model (or a ets("A","N","N") or
exponential smoothing model from the \pkg{forecast} package). If \code{trend} is set \code{TRUE},
then  a  local  trend ssm model is defined (a equivalent ets("A","A","N") or Holt model from the
\pkg{forecast} package). For damped trend models set \code{damped} to \code{TRUE}. If \code{seasonal}
is  set  to  \code{TRUE} a seasonal local level model is defined (a equivalent ets("A","N","A") model
from  the  \pkg{forecast} package). For a Holt-Winters method (ets("A","A","A")) set \code{Trend} and
\code{seasonal} to \code{TRUE}.

When \code{genT} option is \code{TRUE} a t-student innovations ssm model (see Ardia (2010)) is generated
see Fonseca, et. al (2019) for more details.

The default priors used in a ssm( ) model are:

\itemize{
\item{level ~ normal(0,0.5)}
\item{sigma0 ~ t-student(0,1,7)}
\item{level1 ~ normal(0,1)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
mod1 = LocalLevel(ipc)

}
\references{
Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.
}
\seealso{
\code{\link{Sarima}} \code{\link{auto.arima}} \code{\link{set_prior}} \code{\link{garch}}
}
\author{
Asael Alonzo Matamoros.
}
