% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{EFA_Mode_Jumper}
\alias{EFA_Mode_Jumper}
\title{Exploratory Factor Analysis of Continuous Response Data}
\usage{
EFA_Mode_Jumper(Y, M, gamma, burnin, chain_length = 10000L)
}
\arguments{
\item{Y}{A N by J matrix of mean-centered, continuous variables.}

\item{M}{An integer specifying the number of factors.}

\item{gamma}{The value of the mode-jumping tuning parameter. Man and Culpepper (2020) used gamma = 0.5.}

\item{burnin}{Number of burn-in iterations to discard.}

\item{chain_length}{The total number of iterations (burn-in + post-burn-in).}
}
\value{
A list that contains nsamples = chain_length - burnin array draws from the posterior distribution:
\itemize{
\item \code{LAMBDA}: A J by M by nsamples array of sampled loading matrices.
\item \code{PSIs}: A J by nsamples matrix of vector of variable uniquenesses.
\item \code{ROW_OUT}: A matrix of sampled row indices of founding variables for mode-jumping algorithm.
\item \code{F_OUT}: An array of sampled factor scores.
\item \code{ACCEPTED}: Acceptance rates for mode-jumping Metropolis-Hastings (MH) steps.
}
}
\description{
Implement the Man and Culpepper (2020) mode-jumping algorithm to factor analyze continuous response data.
}
\examples{

data(exchangerate)

#Retain complete cases and drop Month_Year column
X<-exchangerate[complete.cases(exchangerate),-1]
X<-apply(X,2, diff)
X<-as.matrix(scale(X))

#Specify the number of factors
my_M<-2

#Run the mode-jumping EFA algorithm
burn_in<-150
chain_length<-300
out <- EFA_Mode_Jumper(X,my_M,gamma=0.5,burnin=burn_in,chain_length)
  
#Rotate all samples to permutation positive lower triangular (PPLT) 
#structure with USD and FRF as factor founding variables
  my_lambda_sample = out$LAMBDA
    for (j in 1:dim(my_lambda_sample)[3]) {
      my_rotate = proposal2(c(1,4),my_lambda_sample[,,j],out$F_OUT[,,j])
      my_lambda_sample[,,j] = my_rotate$lambda
    }
    
#compute posterior mean of PPLT loadings
mLambda<-apply(my_lambda_sample,c(1,2),mean)
      
}
\references{
Man, A. & Culpepper, S. A. (2020). A mode-jumping algorithm for Bayesian factor analysis. Journal of the American Statistical Association, doi:10.1080/01621459.2020.1773833.
}
\author{
Steven Andrew Culpepper, Albert Man
}
