% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.bayesbr.R
\name{predict.bayesbr}
\alias{predict.bayesbr}
\title{Prediction Method for \code{bayesbr} Objects}
\usage{
\method{predict}{bayesbr}(object, newdata = NULL, type = c("response", "link",
"precision", "variance", "quantile"), na.action=c("exclude",
"replace"),at = 0.5,...)
}
\arguments{
\item{object}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{newdata}{A data frame in which to look for variables with which to predict. If omitted, the original observations are used.}

\item{type}{A character containing the types of predictions: if type is \emph{"response"} the function will calculate fitted values for theta; if type is \emph{"link"} the function will calculate the linear predictor for theta and zeta;if type is \emph{"precision"} the function will calculate fitted values for zeta parameter;if type is \emph{"variance"} the function will calculate fitted variances of response; if type is \emph{"quantile"} the function will calculate fitted quantiles of theta values;}

\item{na.action}{Characters provided or treatment used in NA values. If \code{na.action} is equal to exclude (default value), the row containing the NA will be excluded in all variables of the model. If \code{na.action} is equal to replace, the row containing the NA will be replaced by the average of the variable in all variables of the model.}

\item{at}{numeric vector indicating the quantiles that will be informed by the function (only if \code{type = "quantile"}). Its default is 0.5.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A function that informs various types of prediction through a beta regression by the Bayesian view.
}
\examples{
data("CarTask", package = "bayesbr")

bbr = bayesbr(probability~ NFCCscale,data=CarTask,
             iter = 100, mean_betas = c(1,1.2))

predict(bbr, type = "response")
predict(bbr, type = "link")
predict(bbr, type = "precision")
predict(bbr, type = "variance")
predict(bbr, type = "quantile", at = c(0.25, 0.5, 0.75))


df = data.frame(NFCCscale = rnorm(10,4,1.4))

predict(bbr, newdata = df, type = "response")
predict(bbr, newdata = df, type = "link")
predict(bbr, newdata = df, type = "precision")
predict(bbr, newdata = df, type = "variance")
predict(bbr, newdata = df, type = "quantile", at = c(0.25, 0.5, 0.75))
}
\seealso{
\code{\link{bayesbr}},\code{\link{residuals.bayesbr}},\code{\link{pmse}}
}
