% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{mig.trajectories.plot}
\alias{mig.trajectories.plot}
\alias{mig.trajectories.plot.all}
\alias{mig.trajectories.table}
\title{Output of posterior distribution of migration trajectories}
\usage{
mig.trajectories.plot(
  mig.pred,
  country,
  pi = c(80, 95),
  nr.traj = 50,
  mark.estimation.points = FALSE,
  xlim = NULL,
  ylim = NULL,
  type = "b",
  xlab = "Year",
  ylab = "Migration rate",
  main = NULL,
  lwd = c(2, 2, 2, 2, 1),
  col = c("black", "green", "red", "red", "#00000020"),
  show.legend = TRUE,
  add = FALSE,
  scale = FALSE,
  ...
)

mig.trajectories.plot.all(
  mig.pred,
  output.dir = NULL,
  output.type = "png",
  verbose = FALSE,
  ...
)

mig.trajectories.table(mig.pred, country, pi = c(80, 95), ...)
}
\arguments{
\item{mig.pred}{Prediction object of class \code{bayesMig.prediction}.}

\item{country}{Name or numerical code of a location. If it is a country, it can also be given as ISO-2 or ISO-3 characters.}

\item{pi}{Probability interval (as percentage) to be included in the output. It can be a single number or a vector.}

\item{nr.traj}{Number of trajectories to be plotted. If \code{NULL}, all trajectories are plotted, otherwise they are thinned evenly.}

\item{mark.estimation.points}{Logical. If \code{TRUE}, points that were not used in the estimation are shown in a lighter color.}

\item{xlim, ylim, type, xlab, ylab}{Graphical parameters passed to the \code{\link{plot}} function.}

\item{main}{Main title for the plot(s). In \code{mig.trajectories.plot.all} any occurrence of the string 
\dQuote{XXX} is replaced by the name of the appropriate country.}

\item{lwd, col}{Vector of five elements giving the line width and color for: 1. observed data, 
2. imputed values, 3. median, 4. quantiles, 5. trajectories.}

\item{show.legend}{Logical controlling whether a legend should be drawn.}

\item{add}{Logical controlling whether the trajectories should be plotted into a new graphic 
device (\code{FALSE}) or into an existing device (\code{TRUE}). One can use this argument to plot
trajectories from multiple countries into one graphics.}

\item{scale}{Logical. If \code{TRUE}, values are scaled to be \dQuote{per population}, i.e. 
they are divided by \code{pop.denom} passed to \code{\link{run.mig.mcmc}}.}

\item{\dots}{Additional graphical parameters. In addition, for \code{mig.trajectories.plot.all} 
any of the arguments of \code{tfr.trajectories.plot} can be passed here.}

\item{output.dir}{Directory into which resulting plots are written. By default,
the plots are saved into directory {sim.dir}/predictions/migTrajectories.}

\item{output.type}{Type of the resulting plot files. Can be "png", "pdf", "jpeg", "bmp",
"tiff", or "postscript".}

\item{verbose}{Logical value. Switches log messages on and off.}
}
\value{
No return value.
}
\description{
The functions plot/tabulate the posterior distribution of trajectories of net migration rates
    for a given location, or for all locations, including their median and given probability 
    intervals.
}
\details{
\code{mig.trajectories.plot} plots posterior distribution of trajectories of net migration
    rates for a given location. \code{mig.trajectories.table} gives the same output as a table. 
    \code{mig.trajectories.plot.all} creates a set of graphs (one per location) that are stored in 
    \code{output.dir}.
    
    The median and given probability intervals are computed using all available trajectories. 
    Thus, \code{nr.traj} does not influence those values - it is used only to control the number 
    of trajectories in the graphs.
}
\examples{
# See example in ?mig.predict

}
\seealso{
\code{\link{mig.predict}}, \code{\link{summary.bayesMig.prediction}}
}
