% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_models.R
\name{diagnose_models}
\alias{diagnose_models}
\title{Model diagnostics after batch adjustment}
\usage{
diagnose_models(data)
}
\arguments{
\item{data}{Batch-adjusted dataset (in which
\code{\link[batchtma]{adjust_batch}} has stored information on batch
adjustment in the attribute \code{.batchtma})}
}
\value{
List:
\itemize{
\item \code{adjust_method} Method used for batch adjustment
(see \code{\link[batchtma]{adjust_batch}}).
\item \code{markers} Variables of biomarkers for adjustment
\item \code{suffix} Suffix appended to variable names
\item \code{batchvar} Variable indicating batch
\item \code{confounders} Confounders, i.e. determinants of
biomarker levels that differ between batches.
Returned only if used by the model.
\item \code{adjust_parameters} Tibble of parameters used to
obtain adjust biomarker levels. Parameters differ between
methods:
\itemize{
\item \code{simple}, \code{standardize}, and \code{ipw}: Estimated adjustment
parameters are a tibble with one \code{batchmean} per \code{marker}
and \code{.batchvar}.
\item \code{quantreg} returns a tibble with numerous values per
\code{marker} and \code{.batchvar}: unadjusted (\code{un_...}) and
adjusted (\code{ad_...}) estimates of the lower (\code{..._lo}) and
upper quantile (\code{..._hi}) and interquantile range (\code{..._iq}),
plus the lower (\code{all_lo}) and upper quantiles (\code{all_hi})
across all batches.
\item \code{quantnorm} does not explicitly estimate parameters.
}
\item \code{model_fits} List of model fit objects, one
per biomarker. Models differ between methods:
\itemize{
\item \code{standardize}: Linear regression model for the biomarker with
\code{.batchvar} and \code{confounders} as predictors, from which
marginal predictions of batch means for each batch are obtained.
\item \code{ipw}: Logistic (2 batches) or multinomial models for assignment
to a specific batch with \code{.batchvar} as the response and
\code{confounders} as the predictors, used to generate stabilized
inverse-probability weights that are then used in a linear regression
model to estimate marginally standardized batch means.
\item \code{quantreg}: Quantile regression with the marker as the response
variable and \code{.batchvar} and \code{confounders} as predictors.
\item \code{simple} and \code{quantnorm} do not fit any regression models.
}
}
}
\description{
After \code{\link[batchtma]{adjust_batch}} has performed
adjustment for batch effects, \code{diagnose_models}
provides an overview of parameters and adjustment models.
Information is only available about the most recent
run of \code{\link[batchtma]{adjust_batch}} on a dataset.
}
\examples{
# Data frame with two batches
# Batch 2 has higher values of biomarker and confounder
df <- data.frame(
  tma = rep(1:2, times = 10),
  biomarker = rep(1:2, times = 10) +
    runif(max = 5, n = 20),
  confounder = rep(0:1, times = 10) +
    runif(max = 10, n = 20)
)

# Adjust for batch effects
df2 <- adjust_batch(
  data = df,
  markers = biomarker,
  batch = tma,
  method = quantreg,
  confounders = confounder
)

# Show overview of model diagnostics:
diagnose_models(data = df2)

# Obtain first fitted regression model:
fit <- diagnose_models(data = df2)$model_fits[[1]][[1]]

# Obtain residuals for this model:
residuals(fit)
}
