% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_mml}
\alias{setup_mml}
\title{Setup mml Design Object}
\usage{
setup_mml(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{mml}
}
\description{
Creates an object of class \code{mml}.
}
\details{
The class \code{mml} implements a modified version of the
empirical Bayes method by Gravestock & Held (2017) which was proposed for
borrowing strength from an external study. In their approach, the sharing
weight is found as the maximum of the marginal likelihood of the
weight, given the external data set. This leads, however, to
non-symmetric weights when applied to sharing in basket trials, i.e.
Basket i would not share the information from Basket j as the other way
round. Therefore, a symmetrised version is used, where the mean of the
two weights resulting from sharing in both directions is used.
}
\examples{
design_mml <- setup_mml(k = 3, p0 = 0.2)
}
\references{
Gravestock, I., & Held, L. (2017). Adaptive power priors with
empirical Bayes for clinical trials. Pharmaceutical statistics, 16(5),
349-360.
}
