% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_results.mml}
\alias{get_results.mml}
\title{Get Results for Simulation of a Basket Trial with the MML Design}
\usage{
\method{get_results}{mml}(design, n, p1 = NULL, lambda, iter = 1000, data = NULL, ...)
}
\arguments{
\item{design}{An object of class \code{mml}.}

\item{n}{The sample size per basket.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A matrix of results with \code{iter} rows. A 0 means, that the
null hypothesis that the response probability exceeds \code{p0} was not
rejected, a 1 means, that the null hypothesis was rejected.
}
\description{
Get Results for Simulation of a Basket Trial with the MML Design
}
\examples{
design <- setup_mml(k = 3, p0 = 0.2)
get_results(design, n = 20, p1 = c(0.2, 0.5, 0.5), lambda = 0.95,
  iter = 100)
}
