% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeDataframe.R
\name{tree_dataframe}
\alias{tree_dataframe}
\title{Transform tree data into a structured dataframe}
\usage{
tree_dataframe(data, trees, response = NULL)
}
\arguments{
\item{data}{A dataframe containing the raw data used for building the tree.}

\item{trees}{A dataframe representing the initial tree structure, including variables and values for splits.}

\item{response}{Optional character of the name of the response variable in your BART model. Including the response
will remove it from the list elements `Variable names` and `nVar`.}
}
\value{
A list containing a detailed dataframe of the tree structure (`structure`) with added information such as
node depth, parent and child nodes, and observational data, along with meta-information about the tree like
variable names (`varNames`), number of MCMC iterations (`nMCMC`), number of trees (`nTree`), and number of variables (`nVar`).
}
\description{
This function takes raw data and a tree structure, then processes it to form a detailed and structured dataframe.
The data is transformed to indicate terminal nodes, calculate leaf values, and determine split values. It then
assigns labels, calculates node depth, and establishes hierarchical relationships within the tree.
Additional metadata about the tree, such as maximum depth, parent and child node relationships, and observation
nodes are also included. The final dataframe is organized and enriched with necessary attributes for further analysis.
}
\examples{
data("input_data")
data("tree_data_example")
my_trees <- tree_dataframe(data = input_data, trees = tree_data_example, response = "y")

}
