% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda.R
\name{visualize_season}
\alias{visualize_season}
\title{visualize trend of pathogen observation rate for NPPCR data (both cases and controls)}
\usage{
visualize_season(data_nplcm, patho, slice = 1, slice_SS = 1)
}
\arguments{
\item{data_nplcm}{Data set produced by \code{\link[=clean_perch_data]{clean_perch_data()}}}

\item{patho}{the index of pathogen}

\item{slice}{the slice of BrS data for visualization; default is 1.}

\item{slice_SS}{the slice of SS data to add onto BrS plots; default is 1, usually
representing blood culture measurements.}
}
\value{
A figure with smoothed positive rate and confidence bands for cases
and controls, respectively. The right margin shows marginal positive rates; all
rates are only among the subset of case subjects who had non-missing responses
for a measured agent (e.g., pathogen); similarly for controls.
}
\description{
visualize trend of pathogen observation rate for NPPCR data (both cases and controls)
}
\details{
This function shows observed
positive rate for continuous covariates,e.g., enrollment date
in PERCH application. Smoothing is done by penalized splines implemented by
\code{mgcv} package. The penalized spline smoothing term is constructed by
\code{\link[mgcv:smooth.construct.ps.smooth.spec]{mgcv::smooth.construct.ps.smooth.spec()}}. The window size of the moving averages currently is set
to 60 days.
}
\seealso{
Other exploratory data analysis functions: 
\code{\link{get_top_pattern}()},
\code{\link{plot_logORmat}()},
\code{\link{show_individual}()},
\code{\link{summarize_BrS}()},
\code{\link{summarize_SS}()}
}
\concept{exploratory data analysis functions}
