// Generated by rstantools.  Do not edit by hand.

/*
    bakR is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bakR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bakR.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_Mutrate_est_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 21, column 2 to column 33)",
                                                      " (in 'string', line 22, column 2 to column 43)",
                                                      " (in 'string', line 23, column 2 to column 38)",
                                                      " (in 'string', line 27, column 2 to column 60)",
                                                      " (in 'string', line 28, column 2 to column 33)",
                                                      " (in 'string', line 31, column 6 to column 68)",
                                                      " (in 'string', line 30, column 20 to line 32, column 5)",
                                                      " (in 'string', line 30, column 4 to line 32, column 5)",
                                                      " (in 'string', line 29, column 17 to line 33, column 3)",
                                                      " (in 'string', line 29, column 2 to line 33, column 3)",
                                                      " (in 'string', line 58, column 2 to column 21)",
                                                      " (in 'string', line 59, column 2 to column 28)",
                                                      " (in 'string', line 62, column 6 to column 54)",
                                                      " (in 'string', line 61, column 21 to line 63, column 5)",
                                                      " (in 'string', line 61, column 4 to line 63, column 5)",
                                                      " (in 'string', line 65, column 6 to column 45)",
                                                      " (in 'string', line 64, column 21 to line 66, column 5)",
                                                      " (in 'string', line 64, column 4 to line 66, column 5)",
                                                      " (in 'string', line 60, column 18 to line 67, column 3)",
                                                      " (in 'string', line 60, column 2 to line 67, column 3)",
                                                      " (in 'string', line 39, column 6 to column 53)",
                                                      " (in 'string', line 40, column 6 to column 48)",
                                                      " (in 'string', line 38, column 20 to line 41, column 5)",
                                                      " (in 'string', line 38, column 4 to line 41, column 5)",
                                                      " (in 'string', line 37, column 17 to line 42, column 3)",
                                                      " (in 'string', line 37, column 2 to line 42, column 3)",
                                                      " (in 'string', line 46, column 6 to column 43)",
                                                      " (in 'string', line 45, column 19 to line 47, column 5)",
                                                      " (in 'string', line 45, column 4 to line 47, column 5)",
                                                      " (in 'string', line 44, column 18 to line 48, column 3)",
                                                      " (in 'string', line 44, column 2 to line 48, column 3)",
                                                      " (in 'string', line 51, column 4 to line 53, column 107)",
                                                      " (in 'string', line 50, column 18 to line 54, column 3)",
                                                      " (in 'string', line 50, column 2 to line 54, column 3)",
                                                      " (in 'string', line 5, column 2 to column 9)",
                                                      " (in 'string', line 6, column 2 to column 9)",
                                                      " (in 'string', line 7, column 9 to column 11)",
                                                      " (in 'string', line 7, column 2 to column 13)",
                                                      " (in 'string', line 8, column 9 to column 11)",
                                                      " (in 'string', line 8, column 2 to column 13)",
                                                      " (in 'string', line 9, column 2 to column 10)",
                                                      " (in 'string', line 10, column 9 to column 11)",
                                                      " (in 'string', line 10, column 2 to column 13)",
                                                      " (in 'string', line 11, column 14 to column 16)",
                                                      " (in 'string', line 11, column 2 to column 18)",
                                                      " (in 'string', line 12, column 14 to column 16)",
                                                      " (in 'string', line 12, column 2 to column 18)",
                                                      " (in 'string', line 13, column 8 to column 10)",
                                                      " (in 'string', line 13, column 2 to column 12)",
                                                      " (in 'string', line 14, column 14 to column 16)",
                                                      " (in 'string', line 14, column 2 to column 18)",
                                                      " (in 'string', line 15, column 2 to column 11)",
                                                      " (in 'string', line 16, column 10 to column 13)",
                                                      " (in 'string', line 16, column 2 to column 15)",
                                                      " (in 'string', line 17, column 2 to column 10)",
                                                      " (in 'string', line 21, column 28 to column 31)",
                                                      " (in 'string', line 21, column 9 to column 13)",
                                                      " (in 'string', line 22, column 38 to column 41)",
                                                      " (in 'string', line 22, column 18 to column 22)",
                                                      " (in 'string', line 23, column 23 to column 25)",
                                                      " (in 'string', line 23, column 27 to column 30)",
                                                      " (in 'string', line 23, column 32 to column 36)",
                                                      " (in 'string', line 27, column 16 to column 18)",
                                                      " (in 'string', line 27, column 20 to column 23)",
                                                      " (in 'string', line 27, column 25 to column 29)",
                                                      " (in 'string', line 28, column 28 to column 31)",
                                                      " (in 'string', line 28, column 9 to column 13)",
                                                      " (in 'string', line 58, column 17 to column 19)",
                                                      " (in 'string', line 58, column 9 to column 12)",
                                                      " (in 'string', line 59, column 24 to column 26)",
                                                      " (in 'string', line 59, column 9 to column 14)"};
#include <stan_meta_header.hpp>
class model_Mutrate_est final : public model_base_crtp<model_Mutrate_est> {
private:
  int NE;
  int NF;
  std::vector<int> TP;
  std::vector<int> MT;
  int nMT;
  std::vector<int> FE;
  std::vector<int> num_mut;
  std::vector<int> num_obs;
  std::vector<int> R;
  std::vector<double> U_cont;
  int nrep;
  std::vector<double> tl;
  double nU;
  int L2FC_kd_2dim__;
 
public:
  ~model_Mutrate_est() { }
  
  inline std::string model_name() const final { return "model_Mutrate_est"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_Mutrate_est(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_Mutrate_est_namespace::model_Mutrate_est";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 35;
      context__.validate_dims("data initialization","NE","int",
          context__.to_vec());
      NE = std::numeric_limits<int>::min();
      
      current_statement__ = 35;
      NE = context__.vals_i("NE")[(1 - 1)];
      current_statement__ = 36;
      context__.validate_dims("data initialization","NF","int",
          context__.to_vec());
      NF = std::numeric_limits<int>::min();
      
      current_statement__ = 36;
      NF = context__.vals_i("NF")[(1 - 1)];
      current_statement__ = 37;
      validate_non_negative_index("TP", "NE", NE);
      current_statement__ = 38;
      context__.validate_dims("data initialization","TP","int",
          context__.to_vec(NE));
      TP = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 38;
      assign(TP, nil_index_list(), context__.vals_i("TP"),
        "assigning variable TP");
      current_statement__ = 39;
      validate_non_negative_index("MT", "NE", NE);
      current_statement__ = 40;
      context__.validate_dims("data initialization","MT","int",
          context__.to_vec(NE));
      MT = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 40;
      assign(MT, nil_index_list(), context__.vals_i("MT"),
        "assigning variable MT");
      current_statement__ = 41;
      context__.validate_dims("data initialization","nMT","int",
          context__.to_vec());
      nMT = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      nMT = context__.vals_i("nMT")[(1 - 1)];
      current_statement__ = 42;
      validate_non_negative_index("FE", "NE", NE);
      current_statement__ = 43;
      context__.validate_dims("data initialization","FE","int",
          context__.to_vec(NE));
      FE = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 43;
      assign(FE, nil_index_list(), context__.vals_i("FE"),
        "assigning variable FE");
      current_statement__ = 44;
      validate_non_negative_index("num_mut", "NE", NE);
      current_statement__ = 45;
      context__.validate_dims("data initialization","num_mut","int",
          context__.to_vec(NE));
      num_mut = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 45;
      assign(num_mut, nil_index_list(), context__.vals_i("num_mut"),
        "assigning variable num_mut");
      current_statement__ = 46;
      validate_non_negative_index("num_obs", "NE", NE);
      current_statement__ = 47;
      context__.validate_dims("data initialization","num_obs","int",
          context__.to_vec(NE));
      num_obs = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 47;
      assign(num_obs, nil_index_list(), context__.vals_i("num_obs"),
        "assigning variable num_obs");
      current_statement__ = 48;
      validate_non_negative_index("R", "NE", NE);
      current_statement__ = 49;
      context__.validate_dims("data initialization","R","int",
          context__.to_vec(NE));
      R = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 49;
      assign(R, nil_index_list(), context__.vals_i("R"),
        "assigning variable R");
      current_statement__ = 50;
      validate_non_negative_index("U_cont", "NE", NE);
      current_statement__ = 51;
      context__.validate_dims("data initialization","U_cont","double",
          context__.to_vec(NE));
      U_cont = std::vector<double>(NE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 51;
      assign(U_cont, nil_index_list(), context__.vals_r("U_cont"),
        "assigning variable U_cont");
      current_statement__ = 52;
      context__.validate_dims("data initialization","nrep","int",
          context__.to_vec());
      nrep = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      nrep = context__.vals_i("nrep")[(1 - 1)];
      current_statement__ = 53;
      validate_non_negative_index("tl", "nMT", nMT);
      current_statement__ = 54;
      context__.validate_dims("data initialization","tl","double",
          context__.to_vec(nMT));
      tl = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 54;
      assign(tl, nil_index_list(), context__.vals_r("tl"),
        "assigning variable tl");
      current_statement__ = 55;
      context__.validate_dims("data initialization","nU","double",
          context__.to_vec());
      nU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 55;
      nU = context__.vals_r("nU")[(1 - 1)];
      current_statement__ = 56;
      validate_non_negative_index("log_lambda_o", "nMT", nMT);
      current_statement__ = 57;
      validate_non_negative_index("log_lambda_o", "nrep", nrep);
      current_statement__ = 58;
      validate_non_negative_index("TL_lambda_eff", "nMT", nMT);
      current_statement__ = 59;
      validate_non_negative_index("TL_lambda_eff", "nrep", nrep);
      current_statement__ = 60;
      validate_non_negative_index("mu_rep_logit_fn", "NF", NF);
      current_statement__ = 61;
      validate_non_negative_index("mu_rep_logit_fn", "nMT", nMT);
      current_statement__ = 62;
      validate_non_negative_index("mu_rep_logit_fn", "nrep", nrep);
      current_statement__ = 63;
      validate_non_negative_index("frac_new", "NF", NF);
      current_statement__ = 64;
      validate_non_negative_index("frac_new", "nMT", nMT);
      current_statement__ = 65;
      validate_non_negative_index("frac_new", "nrep", nrep);
      current_statement__ = 66;
      validate_non_negative_index("log_lambda_n", "nMT", nMT);
      current_statement__ = 67;
      validate_non_negative_index("log_lambda_n", "nrep", nrep);
      current_statement__ = 68;
      validate_non_negative_index("kd", "NF", NF);
      current_statement__ = 69;
      validate_non_negative_index("kd", "nMT", nMT);
      current_statement__ = 70;
      validate_non_negative_index("L2FC_kd", "NF", NF);
      current_statement__ = 71;
      L2FC_kd_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 71;
      L2FC_kd_2dim__ = (nMT - 1);
      current_statement__ = 71;
      validate_non_negative_index("L2FC_kd", "nMT - 1", L2FC_kd_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nMT * nrep;
      num_params_r__ += nMT * nrep;
      num_params_r__ += NF * nMT * nrep;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_Mutrate_est_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        assign(log_lambda_o, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable log_lambda_o");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        assign(TL_lambda_eff, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable TL_lambda_eff");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0, lp__),
              "assigning variable TL_lambda_eff");
          } else {
            current_statement__ = 2;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
              "assigning variable TL_lambda_eff");
          }}}
      std::vector<std::vector<std::vector<local_scalar_t__>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 3;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 3;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable mu_rep_logit_fn");}}}
      std::vector<std::vector<std::vector<local_scalar_t__>>> frac_new;
      frac_new = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      current_statement__ = 4;
      assign(frac_new, nil_index_list(), inv_logit(mu_rep_logit_fn),
        "assigning variable frac_new");
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_lambda_n;
      log_lambda_n = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nMT, Eigen::Matrix<local_scalar_t__, -1, 1>(nrep));
      stan::math::fill(log_lambda_n, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int j = 1; j <= nMT; ++j) {
        current_statement__ = 8;
        for (int k = 1; k <= nrep; ++k) {
          current_statement__ = 6;
          assign(log_lambda_n,
            cons_list(index_uni(j),
              cons_list(index_uni(k), nil_index_list())),
            (log_lambda_o[(j - 1)][(k - 1)] +
              TL_lambda_eff[(j - 1)][(k - 1)]),
            "assigning variable log_lambda_n");}}
      {
        current_statement__ = 26;
        for (int i = 1; i <= nMT; ++i) {
          current_statement__ = 24;
          for (int k = 1; k <= nrep; ++k) {
            current_statement__ = 21;
            lp_accum__.add(
              normal_lpdf<propto__>(log_lambda_o[(i - 1)][(k - 1)],
                stan::math::log((nU * 0.001)), 0.5));
            current_statement__ = 22;
            lp_accum__.add(
              lognormal_lpdf<propto__>(TL_lambda_eff[(i - 1)][(k - 1)], 1.4,
                0.15));}}
        current_statement__ = 31;
        for (int i = 1; i <= NF; ++i) {
          current_statement__ = 29;
          for (int j = 1; j <= nMT; ++j) {
            current_statement__ = 27;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_rep_logit_fn[(i - 1)][(j - 1)], 0, 1));
          }}
        current_statement__ = 34;
        for (int i = 1; i <= NE; ++i) {
          current_statement__ = 32;
          lp_accum__.add(
            (num_obs[(i - 1)] *
              log_mix(
                (TP[(i - 1)] *
                  frac_new[(FE[(i - 1)] - 1)][(MT[(i - 1)] - 1)][(R[(i - 1)]
                                                                   - 1)]),
                poisson_log_lpmf<false>(num_mut[(i - 1)],
                  (U_cont[(i - 1)] +
                    log_lambda_n[(MT[(i - 1)] - 1)][(R[(i - 1)] - 1)])),
                poisson_log_lpmf<false>(num_mut[(i - 1)],
                  (U_cont[(i - 1)] +
                    log_lambda_o[(MT[(i - 1)] - 1)][(R[(i - 1)] - 1)])))));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_Mutrate_est_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 1;
        assign(log_lambda_o, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable log_lambda_o");}
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        assign(TL_lambda_eff, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nrep), "assigning variable TL_lambda_eff");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 2;
          assign(TL_lambda_eff,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(
              TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable TL_lambda_eff");}}
      std::vector<std::vector<std::vector<double>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 3;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 3;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable mu_rep_logit_fn");}}}
      std::vector<std::vector<std::vector<double>>> frac_new;
      frac_new = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_n;
      log_lambda_n = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_n, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(log_lambda_o[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(TL_lambda_eff[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
            vars__.emplace_back(
              mu_rep_logit_fn[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 4;
      assign(frac_new, nil_index_list(), inv_logit(mu_rep_logit_fn),
        "assigning variable frac_new");
      current_statement__ = 10;
      for (int j = 1; j <= nMT; ++j) {
        current_statement__ = 8;
        for (int k = 1; k <= nrep; ++k) {
          current_statement__ = 6;
          assign(log_lambda_n,
            cons_list(index_uni(j),
              cons_list(index_uni(k), nil_index_list())),
            (log_lambda_o[(j - 1)][(k - 1)] +
              TL_lambda_eff[(j - 1)][(k - 1)]),
            "assigning variable log_lambda_n");}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              vars__.emplace_back(
                frac_new[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            vars__.emplace_back(log_lambda_n[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> kd;
      kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(kd, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> L2FC_kd;
      L2FC_kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(L2FC_kd_2dim__));
      stan::math::fill(L2FC_kd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 20;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 15;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 13;
          assign(kd,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            (-stan::math::log((1 - mean(frac_new[(i - 1)][(j - 1)]))) /
              tl[(j - 1)]), "assigning variable kd");}
        current_statement__ = 18;
        for (int k = 1; k <= (nMT - 1); ++k) {
          current_statement__ = 16;
          assign(L2FC_kd,
            cons_list(index_uni(i),
              cons_list(index_uni(k), nil_index_list())),
            stan::math::log2(
              (kd[(i - 1)][((k + 1) - 1)] / kd[(i - 1)][(1 - 1)])),
            "assigning variable L2FC_kd");}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(kd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(L2FC_kd[(sym2__ - 1)][(sym1__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<Eigen::Matrix<double, -1, 1>> log_lambda_o;
      log_lambda_o = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(log_lambda_o, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log_lambda_o_flat__;
        current_statement__ = 1;
        assign(log_lambda_o_flat__, nil_index_list(),
          context__.vals_r("log_lambda_o"),
          "assigning variable log_lambda_o_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 1;
            assign(log_lambda_o,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              log_lambda_o_flat__[(pos__ - 1)],
              "assigning variable log_lambda_o");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff;
      TL_lambda_eff = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> TL_lambda_eff_flat__;
        current_statement__ = 2;
        assign(TL_lambda_eff_flat__, nil_index_list(),
          context__.vals_r("TL_lambda_eff"),
          "assigning variable TL_lambda_eff_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 2;
            assign(TL_lambda_eff,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              TL_lambda_eff_flat__[(pos__ - 1)],
              "assigning variable TL_lambda_eff");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> TL_lambda_eff_free__;
      TL_lambda_eff_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(nMT, Eigen::Matrix<double, -1, 1>(nrep));
      stan::math::fill(TL_lambda_eff_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          current_statement__ = 2;
          assign(TL_lambda_eff_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(TL_lambda_eff[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable TL_lambda_eff_free__");}}
      std::vector<std::vector<std::vector<double>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> mu_rep_logit_fn_flat__;
        current_statement__ = 3;
        assign(mu_rep_logit_fn_flat__, nil_index_list(),
          context__.vals_r("mu_rep_logit_fn"),
          "assigning variable mu_rep_logit_fn_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 3;
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              current_statement__ = 3;
              assign(mu_rep_logit_fn,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                mu_rep_logit_fn_flat__[(pos__ - 1)],
                "assigning variable mu_rep_logit_fn");
              current_statement__ = 3;
              pos__ = (pos__ + 1);}}}
      }
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          vars__.emplace_back(log_lambda_o[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nrep; ++sym2__) {
          vars__.emplace_back(
            TL_lambda_eff_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            vars__.emplace_back(
              mu_rep_logit_fn[(sym1__ - 1)][(sym2__ - 1)][(sym3__ - 1)]);}}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("log_lambda_o");
    names__.emplace_back("TL_lambda_eff");
    names__.emplace_back("mu_rep_logit_fn");
    names__.emplace_back("frac_new");
    names__.emplace_back("log_lambda_n");
    names__.emplace_back("kd");
    names__.emplace_back("L2FC_kd");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(L2FC_kd_2dim__)
                                             });
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log_lambda_o" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "TL_lambda_eff" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "frac_new" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lambda_n" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "log_lambda_o" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "TL_lambda_eff" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "frac_new" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_lambda_n" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log_lambda_o\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"TL_lambda_eff\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"frac_new\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lambda_n\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"log_lambda_o\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"TL_lambda_eff\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"frac_new\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lambda_n\",\"type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nrep << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_Mutrate_est_namespace::model_Mutrate_est;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Mutrate_est_namespace::profiles__;
}
#endif
#endif
