% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulateInterventions}
\alias{simulateInterventions}
\title{Simulate data of a causal cyclic model under shift interventions.}
\usage{
simulateInterventions(n, p, A, G, intervMultiplier, noiseMult, nonGauss,
  hiddenVars, knownInterventions, fracVarInt, simulateObs, seed = 1)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of variables.}

\item{A}{Connectivity matrix A. The entry \eqn{A_{ij}} contains the edge 
from node i to node j.}

\item{G}{Number of environments, has to be larger than two for \code{backShift}.}

\item{intervMultiplier}{Regulates the strength of the interventions.}

\item{noiseMult}{Regulates the noise variance.}

\item{nonGauss}{Set to \code{TRUE} to generate non-Gaussian noise.}

\item{hiddenVars}{Set to \code{TRUE} to include hidden variables.}

\item{knownInterventions}{Set to \code{TRUE} if location of interventions
should be known.}

\item{fracVarInt}{If \code{knownInterventions} is \code{TRUE}, fraction of 
variables that are intervened on in each environment.}

\item{simulateObs}{If \code{TRUE}, also generate observational data.}

\item{seed}{Random seed.}
}
\value{
A list with the following elements: 
\itemize{
  \item \code{X} (nxp)-dimensional data matrix
  \item \code{environment} Indicator of the experiment or the intervention type an 
  observation belongs to. A numeric vector of length n. 
  \item \code{interventionVar} (Gxp)-dimensional matrix with intervention variances.
  \item \code{interventions} Location of interventions if \code{knownInterventions}
   was set to \code{TRUE}.
  \item \code{configs} A list with the following elements: 
  \itemize{
  \item \code{trueA} True connectivity matrix used to generate the data.
  \item \code{G} Number of environments.
  \item \code{indexObservationalData} Index of observational data
  \item \code{intervMultiplier} Multiplier steering the intervention strength
  \item \code{noiseMult} Multiplier steering the noise level
  \item \code{fracVarInt}  If \code{knownInterventions} was set to \code{TRUE}, 
   fraction of variables that were intervened on in each environment.
  \item \code{hiddenVars} If \code{TRUE}, hidden variables exist.
  \item \code{knownInterventions} If \code{TRUE}, location of interventions is known.
  \item \code{simulateObs} If \code{TRUE}, environment \code{1} contains 
   observational data.
  }
}
}
\description{
Simulate data of a causal cyclic model under shift interventions.
}
\references{
Dominik Rothenhaeusler, Christina Heinze, Jonas Peters, Nicolai Meinshausen (2015):
backShift: Learning causal cyclic graphs from unknown shift interventions.
arXiv preprint: \url{http://arxiv.org/abs/1506.02494}
}
