% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_flow_logs}
\alias{ec2_describe_flow_logs}
\title{Describe Flow Logs}
\usage{
ec2_describe_flow_logs(
  DryRun = NULL,
  Filter = NULL,
  FlowLogId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{FlowLogId}{List.   One or more flow log IDs.  Constraint: Maximum of 1000 flow log IDs.  [optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes one or more flow logs. To view the
information in your flow logs (the log streams for the network
interfaces), you must use the CloudWatch Logs console or the CloudWatch
Logs API.
}
\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{deliver-log-status} - The status of the logs delivery (\code{SUCCESS} \|
\code{FAILED}).
\item \code{log-destination-type} - The type of destination to which the flow
log publishes data. Possible destination types include
\code{cloud-watch-logs} and \code{s3}.
\item \code{flow-log-id} - The ID of the flow log.
\item \code{log-group-name} - The name of the log group.
\item \code{resource-id} - The ID of the VPC, subnet, or network interface.
\item \code{traffic-type} - The type of traffic (\code{ACCEPT} \| \code{REJECT} \|
\code{ALL}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

\section{FlowLogId}{


One or more flow log IDs.

Constraint: Maximum of 1000 flow log IDs.
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

