% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_import_client_vpn_client_certificate_revocation_list}
\alias{ec2_import_client_vpn_client_certificate_revocation_list}
\title{Import Client Vpn Client Certificate Revocation List}
\usage{
ec2_import_client_vpn_client_certificate_revocation_list(
  ClientVpnEndpointId,
  CertificateRevocationList,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint to which the client certificate revocation list applies.}

\item{CertificateRevocationList}{String. The client certificate revocation list file.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Import Client Vpn Client Certificate Revocation List
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint to which the client certificate revocation list
applies.
}

\section{CertificateRevocationList}{

The client certificate revocation list
file. For more information, see \href{https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate}{Generate a Client Certificate Revocation List}
in the \emph{AWS Client VPN Administrator Guide}.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

