% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_key_pair}
\alias{ec2_delete_key_pair}
\title{Delete Key Pair}
\usage{
ec2_delete_key_pair(
  KeyName = NULL,
  KeyPairId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{KeyName}{String. The name of the key pair.[optional]}

\item{KeyPairId}{String. The ID of the key pair.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified key pair, by removing the
public key from Amazon EC2.
}
\section{KeyName}{

The name of the key
pair.
}

\section{KeyPairId}{

The ID of the key
pair.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

