% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpc_endpoint}
\alias{ec2_create_vpc_endpoint}
\title{Create Vpc Endpoint}
\usage{
ec2_create_vpc_endpoint(
  VpcId,
  ServiceName,
  DryRun = NULL,
  VpcEndpointType = NULL,
  PolicyDocument = NULL,
  RouteTableId = NULL,
  SubnetId = NULL,
  SecurityGroupId = NULL,
  ClientToken = NULL,
  PrivateDnsEnabled = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcId}{String. The ID of the VPC in which the endpoint will be used.}

\item{ServiceName}{String. The service name.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VpcEndpointType}{String.   The type of endpoint.  Default: Gateway  [optional]}

\item{PolicyDocument}{String. (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the...[optional]}

\item{RouteTableId}{List. (Gateway endpoint) One or more route table IDs.[optional]}

\item{SubnetId}{List. (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create...[optional]}

\item{SecurityGroupId}{List. (Interface endpoint) The ID of one or more security groups to associate with the endpoint network...[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{PrivateDnsEnabled}{Logical.   (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC.[optional]}

\item{TagSpecification}{List. The tags to associate with the endpoint.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Vpc Endpoint
}
\section{VpcId}{

The ID of the VPC in which the endpoint will be
used.
}

\section{ServiceName}{

The service name. To get a list of available
services, use the DescribeVpcEndpointServices request, or get the name
from the service provider.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{VpcEndpointType}{


The type of endpoint.

Default: Gateway
}

\section{PolicyDocument}{

(Interface and gateway endpoints) A policy to
attach to the endpoint that controls access to the service. The policy
must be in valid JSON format. If this parameter is not specified, we
attach a default policy that allows full access to the
service.
}

\section{RouteTableId}{

(Gateway endpoint) One or more route table
IDs.
}

\section{SubnetId}{

(Interface and Gateway Load Balancer endpoints)
The ID of one or more subnets in which to create an endpoint network
interface. For a Gateway Load Balancer endpoint, you can specify one
subnet only.
}

\section{SecurityGroupId}{

(Interface endpoint) The ID of one or
more security groups to associate with the endpoint network
interface.
}

\section{ClientToken}{

Unique, case-sensitive identifier that
you provide to ensure the idempotency of the request. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

\section{PrivateDnsEnabled}{


(Interface endpoint) Indicates whether to associate a private hosted
zone with the specified VPC. The private hosted zone contains a record
set for the default public DNS name for the service for the Region (for
example, \verb{kinesis.us-east-1.amazonaws.com}), which resolves to the
private IP addresses of the endpoint network interfaces in the VPC. This
enables you to make requests to the default public DNS name for the
service instead of the public DNS names that are automatically generated
by the VPC endpoint service.

To use a private hosted zone, you must set the following VPC attributes
to \code{true}: \code{enableDnsHostnames} and \code{enableDnsSupport}. Use
ModifyVpcAttribute to set the VPC attributes.

Default: \code{true}
}

\section{TagSpecification}{

The tags to associate with the
endpoint.
}

