% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tandem_id_from_logic_operation.R
\name{get_tandem_id_from_logic_operation}
\alias{get_tandem_id_from_logic_operation}
\title{Get tandem repeat from logic operations}
\usage{
get_tandem_id_from_logic_operation(
  logic_operation,
  seed_id = sample(1:1000, 1),
  tandem_seq = FALSE,
  tandem_pos = FALSE
)
}
\arguments{
\item{logic_operation}{List of logical functions from the following set:
"equals", "exclusive or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not".}

\item{seed_id}{Integer (from 1 to 1000) or a vector of integer values. This
integer is used for starting the pseudo-random number generator that
represents the environment experiencing a digital organism. If seed_id value
is not specified, it returns data for a single randomly chosen seed_id value
(between 1 and 1000).}

\item{tandem_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{tandem_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "tandem_id", "tandem_seq"
(optional), "tandem_pos" (optional).
}
\description{
Get the tandem repeat contained in the transcriptome of a
digital organism that executes a specific combination of logic operations.
}
\examples{

# Single logic operation
get_tandem_id_from_logic_operation(logic_operation = "not")

# More than one logic operation
get_tandem_id_from_logic_operation(
  logic_operation = c("not", "and"),
  tandem_seq = TRUE
)

# At seed_1 and seed_2
get_tandem_id_from_logic_operation(
  logic_operation = c("not", "and"),
  tandem_seq = TRUE,
  tandem_pos = TRUE,
  seed_id = c(1,2)
)

}
