% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_datamatrix.r
\name{impute_datamatrix}
\alias{impute_datamatrix}
\title{Imputes the missing values in the input data}
\usage{
impute_datamatrix(data_matrix, measurements_per_day, imputation_iterations)
}
\arguments{
\item{data_matrix}{The raw, unimputed data matrix.}

\item{measurements_per_day}{The number of measurements per day. This variable is used for adding day part dummy variables to aid the imputation.}

\item{imputation_iterations}{The amount of times the Amelia imputation should be averaged over.}
}
\value{
This function returns the modified matrix.
}
\description{
This function uses \code{Amelia::amelia} to impute missing (\code{NA}) values in the input data set. This function averages over multiple Amelia imputations to obtain more consistent results. The Amelia imputation model uses all variables of the supplied \code{data_matrix}, the first lag of those variables, time, time squared, and day-part dummies.
}
\examples{
# create a matrix with some missing values
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, nrow(data_matrix))
while (sum(is.na(data_matrix)) == 0)
  data_matrix[as.logical(round(runif(ncol(data_matrix) * nrow(data_matrix), -0.3, 0.7)))] <- NA
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
data_matrix
autovarCore:::impute_datamatrix(data_matrix, 1, 100)
}
