% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_skewness.r
\name{assess_skewness}
\alias{assess_skewness}
\title{Tests the skewness of a VAR model}
\usage{
assess_skewness(varest)
}
\arguments{
\item{varest}{A \code{varest} model.}
}
\value{
This function returns a p-level.
}
\description{
This function tests the skewness for the residuals of the endogenous variables in the specified VAR model. This function uses an implementation equivalent to STATA's \code{sktest}. Of the p-levels resulting from assessing the significance of the skewness for the residuals of that variable, the minimum is returned.
}
\examples{
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, nrow(data_matrix))
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
varest <- autovarCore:::run_var(data_matrix, NULL, 1)
autovarCore:::assess_skewness(varest)
}
