% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_forecast.R
\name{stsm_filter}
\alias{stsm_filter}
\title{Kalman Filter}
\usage{
stsm_filter(
  model,
  y,
  freq = NULL,
  exo = NULL,
  ci = 0.8,
  plot = FALSE,
  plot.decomp = FALSE,
  smooth = TRUE
)
}
\arguments{
\item{model}{Structural time series model estimated using stsm_estimate.}

\item{y}{Univariate time series of data values. May also be a 2 column data frame containing a date column.}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily)), default is NULL and will be automatically detected}

\item{exo}{Matrix of exogenous variables used for the historical data. Can be used to specify regression effects or other seasonal effects like holidays, etc.}

\item{ci}{Confidence interval, value between 0 and 1 exclusive.}

\item{plot, }{Logical, whether to plot everything}

\item{plot.decomp}{Logical, whether to plot the filtered historical data}

\item{smooth}{Whether or not to use the Kalman smoother}
}
\value{
data table (or list of data tables) containing the filtered and/or smoothed series.
}
\description{
Kalman filter an estimated model from stsm_estimate output. This is a wrapper to stsm_forecast with n.ahead = 0.
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
stsm = stsm_estimate(NA000334Q)
fc = stsm_filter(stsm, y = NA000334Q, plot = TRUE)
}
}
